/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  init.c
//  Initialization of the uC
//
//  Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#include "main.h"



// General initializations
void init_general(void)
{  
  // set frequency of DCO to 16MHz, using calibrated register settings
  BCSCTL1 = CALBC1_16MHZ;
  DCOCTL = CALDCO_16MHZ;
  
  // select DCO for MCLK
  clear_bit(BCSCTL2, SELM0);
  clear_bit(BCSCTL2, SELM1);
  
  // no divider for MCLK
  clear_bit(BCSCTL2, DIVM0);
  clear_bit(BCSCTL2, DIVM1);
  
  // select DCO for SMCLK
  clear_bit(BCSCTL2, SELS);
  
  // no divider for SMCLK
  clear_bit(BCSCTL2, DIVS0);
  clear_bit(BCSCTL2, DIVS1);
  
  // disable second crystal oscillator XT2
  clear_bit(BCSCTL1, XT2OFF);

  // set divider 8 for ACLK
  set_bit(BCSCTL1, DIVA1);
  set_bit(BCSCTL1, DIVA0);
}

// UART initialization to 9600 Baud Rate, 8 bit, no parity
void init_uart(void)
{
  P3SEL |= 0x30;                            // P3.4,5 = USCI_A0 TXD/RXD
  UCA0CTL1 |= UCSSEL_2;                     // CLK = SMCLK
  UCA0BR0 = 0x82;                           // 16MHz/9600 = 1666 (hex = 682)
  UCA0BR1 = 0x06;
  UCA0MCTL = UCBRS2 + UCBRS1;               // Modulation UCBRSx = 6
  UCA0CTL0 = 0x00;							// Parity disabled, LSB first, 8-bit data, one stop bit, UART mode, Async. mode
  UCA0CTL1 &= ~UCSWRST;                     // **Initialize USCI state machine**
  IE2 |= UCA0RXIE + UCA0TXIE;               // Enable USCI_A0 TX/RX interrupt

  //__bis_SR_register(LPM3_bits + GIE);       // Enter LPM3 w/ interrupts enabled
}

// Initialization of LCD backlight
// the backlight is switched on when the pin is high
void init_backlight(void)
{
	// set pin as output
	set_bit(BLIGHT_PDIR, BLIGHT_BIT);
	
	// disable pullup
	clear_bit(BLIGHT_RES, BLIGHT_BIT);
	
	// set I/O function
	clear_bit(BLIGHT_PSEL, BLIGHT_BIT);
	
	// set output low (LCD backlight off)
	clear_bit(BLIGHT_POUT, BLIGHT_BIT);
}

// // Initialization of LEDs: they will switch ON when the pin is HIGH

// Green LED
void init_green_led(void)
{
	// set pin as output
	set_bit(LED_PDIR, LED_GREEN_BIT);

	// disable pullup
	clear_bit(LED_RES, LED_GREEN_BIT);

	// set I/O function
	clear_bit(LED_PSEL, LED_GREEN_BIT);

	// set output high (LED off)
	set_bit(LED_POUT, LED_GREEN_BIT);
}

// Yellow LED
void init_yellow_led(void)
{
	// set pin as output
	set_bit(LED_PDIR, LED_YELLOW_BIT);
	
	// disable pullup
	clear_bit(LED_RES, LED_YELLOW_BIT);
	
	// set I/O function
	clear_bit(LED_PSEL, LED_YELLOW_BIT);
	
	// set output high (LED off)
	set_bit(LED_POUT, LED_YELLOW_BIT);
}

// Red LED
void init_red_led(void)
{
	// set pin as output
	set_bit(LED_PDIR, LED_RED_BIT);

	// disable pullup
	clear_bit(LED_RES, LED_RED_BIT);

	// set I/O function
	clear_bit(LED_PSEL, LED_RED_BIT);

	// set output high (LED off)
	set_bit(LED_POUT, LED_RED_BIT);
}


// Initialization of enable Full Bridge output
// The DC/DC Full Bridge is running when the output is high.
void init_fb_enable(void)
{
	// set output low (Full Bridge off)
	clear_bit(ENABLE_FB_POUT, ENABLE_FB_BIT);

	// set pin as output
	set_bit(ENABLE_FB_PDIR, ENABLE_FB_BIT);

	// disable pullup
	clear_bit(ENABLE_FB_RES, ENABLE_FB_BIT);

	// set I/O function
	clear_bit(ENABLE_FB_PSEL, ENABLE_FB_BIT);

}

// Initialization of the PFC Boost enable output
// The Boost PFC stage is running when the output is high.
void init_pfc_enable(void)
{
	// set output low (PFC Stage off)
	clear_bit(ENABLE_PFC_POUT, ENABLE_PFC_BIT);

	// set pin as output
	set_bit(ENABLE_PFC_PDIR, ENABLE_PFC_BIT);

	// disable pullup
	clear_bit(ENABLE_PFC_RES, ENABLE_PFC_BIT);

	// set I/O function
	clear_bit(ENABLE_PFC_PSEL, ENABLE_PFC_BIT);

}

// Initialization of the PFC precharge relay output
// The PFC Relay is closed when the output is high.
void init_precharge_relay(void)
{
	// set output low (PFC Relay off)
	clear_bit(PRECHARGE_RELAY_POUT, PRECHARGE_RELAY_BIT);

	// set pin as output
	set_bit(PRECHARGE_RELAY_PDIR, PRECHARGE_RELAY_BIT);

	// disable pullup
	clear_bit(PRECHARGE_RELAY_RES, PRECHARGE_RELAY_BIT);

	// set I/O function
	clear_bit(PRECHARGE_RELAY_PSEL, PRECHARGE_RELAY_BIT);

}

// Initialization of the Load Connect output function
// The Load is connected output is high.
void init_load_connect(void)
{
	// set output low (Load disconnected)
	clear_bit(LOAD_CONNECT_POUT, LOAD_CONNECT_BIT);

	// set pin as output
	set_bit(LOAD_CONNECT_PDIR, LOAD_CONNECT_BIT);

	// disable pullup
	clear_bit(LOAD_CONNECT_RES, LOAD_CONNECT_BIT);

	// set I/O function
	clear_bit(LOAD_CONNECT_PSEL, LOAD_CONNECT_BIT);

}

// Initialization of the the Full Bridge precharge FETs
// The precharge FETs are ON if the output is high.
void init_precharge_fets(void)
{
	// set output low (Precharge FETs OFF)
	clear_bit(PRECHARGE_FB_POUT, PRECHARGE_FB_BIT);

	// set pin as output
	set_bit(PRECHARGE_FB_PDIR, PRECHARGE_FB_BIT);
	
	// disable pullup
	clear_bit(PRECHARGE_FB_RES, PRECHARGE_FB_BIT);
	
	// set I/O function
	clear_bit(PRECHARGE_FB_PSEL, PRECHARGE_FB_BIT);
	
}

// Initialization of the the FB precharge fail input pin
// The system goes into fail if the pin remains high
void init_fail_precharge(void)
{
	// set pin as input
	clear_bit(FAIL_PRECHARGE_PDIR, FAIL_PRECHARGE_BIT);

	// disable pullup
	clear_bit(FAIL_PRECHARGE_RES, FAIL_PRECHARGE_BIT);

	// set I/O function
	clear_bit(FAIL_PRECHARGE_PSEL, FAIL_PRECHARGE_BIT);
}

// Initialization of the PFC Power Good input (PFC_PGD) pin
// The system goes back from State > 4 to State 4 (DC/DC disabled) if this pin is high (underoltage lockout @ the PFC voltage)
void init_pfc_pgd(void)
{
	// set pin as input
	clear_bit(PFC_PGD_PDIR, PFC_PGD_BIT);

	// disable pullup
	clear_bit(PFC_PGD_RES, PFC_PGD_BIT);

	// set I/O function
	clear_bit(PFC_PGD_PSEL, PFC_PGD_BIT);
}

// Initialization of Fan PWM input
void init_fan(void)
{
	// set pin as input
	clear_bit(fan_PDIR, fan_BIT);

	// disable pullup
	clear_bit(fan_RES, fan_BIT);

	// set I/O function
	clear_bit(fan_PSEL, fan_BIT);

}


